const express = require("express");
const { 
  getProfile, 
  updateProfile,
  updatePersonalInfo,
  updateAddress,
  updateInsurance,
  updateEmergencyContact,
  verifyCCCD
} = require("../controllers/profileController");
const { authenticate } = require("../middleware/authMiddleware");
const { uploadCCCD } = require("../middleware/upload");

const router = express.Router();

// All routes require authentication
router.get("/", authenticate, getProfile);
router.put("/", authenticate, updateProfile); // Legacy endpoint

// Specific update endpoints
router.put("/personal-info", authenticate, updatePersonalInfo);
router.put("/address", authenticate, updateAddress);
router.put("/insurance", authenticate, updateInsurance);
router.put("/emergency-contact", authenticate, updateEmergencyContact);
router.post("/verify-cccd", authenticate, uploadCCCD, verifyCCCD);

module.exports = router;
