const jwt = require("jsonwebtoken");
const User = require("../models/User");

const SECRET_KEY = process.env.JWT_SECRET || "MY_SECRET_KEY";

exports.authenticate = async (req, res, next) => {
  try {
    const token = req.headers.authorization?.split(" ")[1] || req.headers.authorization;

    if (!token) {
      return res.status(401).json({ message: "Không có token xác thực" });
    }

    let decoded;
    try {
      decoded = jwt.verify(token, SECRET_KEY);
    } catch (error) {
      if (error.name === "TokenExpiredError") {
        return res.status(401).json({ 
          message: "Token đã hết hạn",
          code: "TOKEN_EXPIRED"
        });
      }
      return res.status(401).json({ 
        message: "Token không hợp lệ",
        code: "TOKEN_INVALID"
      });
    }

    const user = await User.findById(decoded.id).select("-password -refreshTokens");

    if (!user) {
      return res.status(401).json({ message: "Người dùng không tồn tại" });
    }

    if (user.status !== "active") {
      return res.status(403).json({ message: "Tài khoản đã bị khóa" });
    }

    req.user = user;
    next();
  } catch (error) {
    res.status(500).json({ message: error.message || "Lỗi xác thực" });
  }
};

// Optional authentication - doesn't fail if no token
exports.optionalAuthenticate = async (req, res, next) => {
  try {
    const token = req.headers.authorization?.split(" ")[1] || req.headers.authorization;

    if (token) {
      try {
        const decoded = jwt.verify(token, SECRET_KEY);
        const user = await User.findById(decoded.id).select("-password -refreshTokens");
        if (user && user.status === "active") {
          req.user = user;
        }
      } catch (error) {
        // Ignore token errors for optional auth
      }
    }
    next();
  } catch (error) {
    next();
  }
};

